using System.Collections.Generic;
using UnityEngine;

public class PathVisualizer : MonoBehaviour
{
    [SerializeField] private GameObject waypointPrefab;
    [SerializeField] private LineRenderer lineRenderer;

    private readonly List<GameObject> instantiatedNodes = new();

    public void ClearPath()
    {
        foreach (var node in instantiatedNodes)
            Destroy(node);
        instantiatedNodes.Clear();
        lineRenderer.positionCount = 0;
    }

    public GameObject PlaceNode(Vector3 position)
    {
        var node = Instantiate(waypointPrefab, position, Quaternion.identity, transform);
        instantiatedNodes.Add(node);
        return node;
    }

    public void DrawPath(Vector3 start, Vector3 end)
    {
        lineRenderer.positionCount = 2;
        lineRenderer.SetPositions(new[] { start, end });
    }
}
